/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import java.io.FileDescriptor;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.python.constantine.platform.Errno;
import org.python.constantine.platform.windows.LastError;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.BaseNativePOSIX;
import org.python.posix.FileStat;
import org.python.posix.Group;
import org.python.posix.LibCProvider;
import org.python.posix.POSIXHandler;
import org.python.posix.Passwd;
import org.python.posix.UTimBuf64;
import org.python.posix.WindowsFileStat;
import org.python.posix.WindowsLibC;

final class WindowsPOSIX
extends BaseNativePOSIX {
    private static final int FILE_TYPE_CHAR = 2;
    private static final Map<Integer, Errno> errorToErrnoMapper = new HashMap<Integer, Errno>();

    WindowsPOSIX(String string, LibCProvider libCProvider, POSIXHandler pOSIXHandler) {
        super(string, libCProvider, pOSIXHandler);
    }

    public BaseHeapFileStat allocateStat() {
        return new WindowsFileStat(this);
    }

    public int kill(int n, int n2) {
        this.handler.unimplementedError("kill");
        return -1;
    }

    public int chown(String string, int n, int n2) {
        return 0;
    }

    public int getegid() {
        this.handler.unimplementedError("egid");
        return -1;
    }

    public int setegid(int n) {
        this.handler.unimplementedError("setegid");
        return -1;
    }

    public int geteuid() {
        return 0;
    }

    public int seteuid(int n) {
        this.handler.unimplementedError("seteuid");
        return -1;
    }

    public int getuid() {
        return 0;
    }

    public int setuid(int n) {
        this.handler.unimplementedError("setuid");
        return -1;
    }

    public int getgid() {
        this.handler.unimplementedError("getgid");
        return -1;
    }

    public int setgid(int n) {
        this.handler.unimplementedError("setgid");
        return -1;
    }

    public int getpgid(int n) {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int getpgid() {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int setpgid(int n, int n2) {
        this.handler.unimplementedError("setpgid");
        return -1;
    }

    public int getpriority(int n, int n2) {
        this.handler.unimplementedError("getpriority");
        return -1;
    }

    public int setpriority(int n, int n2, int n3) {
        this.handler.unimplementedError("setpriority");
        return -1;
    }

    public int getppid() {
        return 0;
    }

    public int lchmod(String string, int n) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public int lchown(String string, int n, int n2) {
        this.handler.unimplementedError("lchown");
        return -1;
    }

    public FileStat lstat(String string) {
        return this.stat(string);
    }

    public String readlink(String string) {
        this.handler.unimplementedError("readlink");
        return null;
    }

    public int utimes(String string, long[] lArray, long[] lArray2) {
        UTimBuf64 uTimBuf64 = null;
        if (lArray != null && lArray2 != null) {
            uTimBuf64 = new UTimBuf64(lArray[0], lArray2[0]);
        }
        return ((WindowsLibC)this.libc())._utime64(string, uTimBuf64);
    }

    public int wait(int[] nArray) {
        this.handler.unimplementedError("wait");
        return -1;
    }

    public int waitpid(int n, int[] nArray, int n2) {
        this.handler.unimplementedError("waitpid");
        return -1;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int endgrent() {
        return 0;
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public Group getgrent() {
        return null;
    }

    public Passwd getpwent() {
        return null;
    }

    public Group getgrgid(int n) {
        return null;
    }

    public Passwd getpwnam(String string) {
        return null;
    }

    public Group getgrnam(String string) {
        return null;
    }

    public int setgrent() {
        return 0;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public Passwd getpwuid(int n) {
        return null;
    }

    public boolean isatty(FileDescriptor fileDescriptor) {
        int n = (int)this.helper.gethandle(fileDescriptor);
        int n2 = ((WindowsLibC)this.libc()).GetFileType(n);
        return n2 == 2;
    }

    public int mkdir(String string, int n) {
        try {
            byte[] byArray = WindowsPOSIX.appendWcharNul(string.getBytes("UTF-16LE"));
            int n2 = ((WindowsLibC)this.libc())._wmkdir(byArray);
            if (n2 < 0) {
                int n3 = this.errno();
                this.handler.error(WindowsPOSIX.mapErrorToErrno(n3), string);
            }
            return n2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.handler.error(Errno.EINVAL, string);
            return -1;
        }
    }

    public int link(String string, String string2) {
        boolean bl = ((WindowsLibC)this.libc()).CreateHardLinkA(string2, string, null);
        if (!bl) {
            int n = this.errno();
            this.handler.error(WindowsPOSIX.mapErrorToErrno(n), string + " or " + string2);
            return n;
        }
        return 0;
    }

    private static Errno mapErrorToErrno(int n) {
        Errno errno2 = errorToErrnoMapper.get(n);
        if (errno2 == null) {
            errno2 = Errno.__UNKNOWN_CONSTANT__;
        }
        return errno2;
    }

    private static byte[] appendWcharNul(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        byArray2[byArray.length + 1] = 0;
        return byArray2;
    }

    static {
        errorToErrnoMapper.put(LastError.ERROR_INVALID_FUNCTION.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_FILE_NOT_FOUND.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_PATH_NOT_FOUND.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_TOO_MANY_OPEN_FILES.value(), Errno.EMFILE);
        errorToErrnoMapper.put(LastError.ERROR_ACCESS_DENIED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_HANDLE.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.ERROR_ARENA_TRASHED.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_NOT_ENOUGH_MEMORY.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_BLOCK.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_BAD_ENVIRONMENT.value(), Errno.E2BIG);
        errorToErrnoMapper.put(LastError.ERROR_BAD_FORMAT.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_ACCESS.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_DATA.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_DRIVE.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_CURRENT_DIRECTORY.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_NOT_SAME_DEVICE.value(), Errno.EXDEV);
        errorToErrnoMapper.put(LastError.ERROR_NO_MORE_FILES.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_WRITE_PROTECT.value(), Errno.EROFS);
        errorToErrnoMapper.put(LastError.ERROR_BAD_UNIT.value(), Errno.ENODEV);
        errorToErrnoMapper.put(LastError.ERROR_NOT_READY.value(), Errno.ENXIO);
        errorToErrnoMapper.put(LastError.ERROR_BAD_COMMAND.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_CRC.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_LENGTH.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SEEK.value(), Errno.EIO);
        errorToErrnoMapper.put(LastError.ERROR_NOT_DOS_DISK.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SECTOR_NOT_FOUND.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_OUT_OF_PAPER.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_WRITE_FAULT.value(), Errno.EIO);
        errorToErrnoMapper.put(LastError.ERROR_READ_FAULT.value(), Errno.EIO);
        errorToErrnoMapper.put(LastError.ERROR_GEN_FAILURE.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_LOCK_VIOLATION.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SHARING_VIOLATION.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_WRONG_DISK.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SHARING_BUFFER_EXCEEDED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_NETPATH.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_NETWORK_ACCESS_DENIED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_NET_NAME.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_FILE_EXISTS.value(), Errno.EEXIST);
        errorToErrnoMapper.put(LastError.ERROR_CANNOT_MAKE.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_FAIL_I24.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_PARAMETER.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_NO_PROC_SLOTS.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(LastError.ERROR_DRIVE_LOCKED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BROKEN_PIPE.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_DISK_FULL.value(), Errno.ENOSPC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_TARGET_HANDLE.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_HANDLE.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_WAIT_NO_CHILDREN.value(), Errno.ECHILD);
        errorToErrnoMapper.put(LastError.ERROR_CHILD_NOT_COMPLETE.value(), Errno.ECHILD);
        errorToErrnoMapper.put(LastError.ERROR_DIRECT_ACCESS_HANDLE.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.ERROR_NEGATIVE_SEEK.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_SEEK_ON_DEVICE.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_DIR_NOT_EMPTY.value(), Errno.ENOTEMPTY);
        errorToErrnoMapper.put(LastError.ERROR_DIRECTORY.value(), Errno.ENOTDIR);
        errorToErrnoMapper.put(LastError.ERROR_NOT_LOCKED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_PATHNAME.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_MAX_THRDS_REACHED.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(LastError.ERROR_LOCK_FAILED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_ALREADY_EXISTS.value(), Errno.EEXIST);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_STARTING_CODESEG.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_STACKSEG.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_MODULETYPE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_EXE_SIGNATURE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_EXE_MARKED_INVALID.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_BAD_EXE_FORMAT.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_ITERATED_DATA_EXCEEDS_64k.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_MINALLOCSIZE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_DYNLINK_FROM_INVALID_RING.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_IOPL_NOT_ENABLED.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_SEGDPL.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_AUTODATASEG_EXCEEDS_64k.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_RING2SEG_MUST_BE_MOVABLE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_RELOC_CHAIN_XEEDS_SEGLIM.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INFLOOP_IN_RELOC_CHAIN.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_FILENAME_EXCED_RANGE.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_NESTING_NOT_ALLOWED.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(229, Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_BAD_PIPE.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_PIPE_BUSY.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(LastError.ERROR_NO_DATA.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_PIPE_NOT_CONNECTED.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_OPERATION_ABORTED.value(), Errno.EINTR);
        errorToErrnoMapper.put(LastError.ERROR_NOT_ENOUGH_QUOTA.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_MOD_NOT_FOUND.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.WSAENAMETOOLONG.value(), Errno.ENAMETOOLONG);
        errorToErrnoMapper.put(LastError.WSAENOTEMPTY.value(), Errno.ENOTEMPTY);
        errorToErrnoMapper.put(LastError.WSAEINTR.value(), Errno.EINTR);
        errorToErrnoMapper.put(LastError.WSAEBADF.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.WSAEACCES.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.WSAEFAULT.value(), Errno.EFAULT);
        errorToErrnoMapper.put(LastError.WSAEINVAL.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.WSAEMFILE.value(), Errno.EMFILE);
    }
}

